//----------------------------------------------------------------------------
//
// Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
//
// Use, modification and distribution are subject to the Boost Software
// License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)
//
//----------------------------------------------------------------------------

// This is an example program for using the COM interface of SIMCA-Q dll. To build and 
// run this application you must copy SIMCAQ.tlb to the same directory where you have 
// put the source files.
//
// You must also register the SIMCA-Q.dll with regsvr32.

#pragma once

#import "SIMCAQ.tlb"
using namespace SIMCAQLib;

/////////////////////////////////////////////////////////////////////////////
// CSQPCOMSampleDlg dialog

class CSQPCOMSampleDlg : public CDialog
{
   DECLARE_MESSAGE_MAP()

public:
   explicit CSQPCOMSampleDlg(CWnd* pParent = nullptr);	// standard constructor
   ~CSQPCOMSampleDlg();

   enum { IDD = IDD_SQPCOMCLIENT_DIALOG };

   void DoDataExchange(CDataExchange* pDX) override;	// DDX/DDV support
   BOOL OnInitDialog() override;

   void CreateSQP();
   void GetModelParameters(long nModelNumber);
   void GetResults(IPredictionPtr& pPrediction, long nModelNumber);
   void PrintFloatMatrix(IFloatMatrixPtr& pfMat);

private:
   ISIMCAQPtr mpSQ;
   IProjectPtr mpProject;
   FILE* mpFile = nullptr;
   HICON m_hIcon;

public:
   afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
   afx_msg void OnPaint();
   afx_msg HCURSOR OnQueryDragIcon();
   afx_msg void OnStartSQP();
};
